/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;

import java.util.List;

import jp.mosp.system.dto.MCodeDto;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

public class MCodeDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE	= "M_CODE";
	public static final String KEY_1	= "TID";	//R[h
	public static final String KEY_2	= "TCODE";	//R[h

	// 
	public static final String COL_TID  		= "TID";		//R[h
	public static final String COL_TCODE  	= "TCODE";		//R[h
	public static final String COL_TNAME  	= "TNAME";		//R[h
	public static final String COL_TCHANGE	= "TCHANGE";	//R[hϊ

	/**
	 * RXgN^
	 */
	public MCodeDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MCodeDto> mappingAll() throws SQLException {
		List<MCodeDto> all = new ArrayList<MCodeDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_codeDto m_codeR[h
	 * @throws SQLException
	 */
	private MCodeDto mapping() throws SQLException {
		MCodeDto dto = new MCodeDto();
		dto.setTId 		(rs.getString (COL_TID));		//R[h
		dto.setTCode 	(rs.getString (COL_TCODE));		//R[h
		dto.setTName 	(rs.getString (COL_TNAME));		//R[h
		dto.setTChange 	(rs.getString (COL_TCHANGE));	//R[hϊ
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ʎ擾(DTOList)(findAllTIdp)
	 * @return Xg
	 * @throws SQLException
	 */
	private List<MCodeDto> mappingAllTId() throws SQLException {
		List<MCodeDto> all = new ArrayList<MCodeDto>();
		while (rs.next()) {
			MCodeDto dto = new MCodeDto();
			dto.setTId(rs.getString(COL_TID));
			all.add(dto);
		}
		return all;
	}

	/**
	 * L[ɂf[^擾
	 * @param tid R[h(L[)
	 * @param tcode R[h(L[)
	 * @return m_codeDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MCodeDto findForKey(
			String tid,
			String tcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, tid);
			setParam(index++, tcode);
			executeQuery();
			MCodeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param tid R[h(L[)
	 * @param tcode R[h(L[)
	 * @return m_codeDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MCodeDto findForUpdate(
			String tid,
			String tcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, tid);
			setParam(index++, tcode);
			executeQuery();
			MCodeDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂsbN
	 * @param tid R[h
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void findForUpdate(
			String tid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, tid);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tid R[h
	 * @param tcode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findForCondition(
			String tid,
			String tcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? AND ");
		sb.append(COL_TCODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tid);
			setParam(index++, tcode + "%");
			executeQuery();
			List<MCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tid R[h
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findForHoliday(
			String tid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? AND ");
		sb.append(COL_TCODE);
		sb.append(" != '' ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tid);
			executeQuery();
			List<MCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tid R[h
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findForCondition(
			String tid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tid);
			executeQuery();
			List<MCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tid R[h
	 * @return dto DTO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MCodeDto findForDto(
			String tid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tid);
			executeQuery();
			MCodeDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾(p)
	 * @param tId        R[h敪(L[)
	 * @param tCode      R[h(L[)
	 * @param tName      R[h(L[)
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findForSearch(
			String tId,
			String tCode,
			String tName
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (!tId.equals("")) {
			sb.append(COL_TID);
			sb.append(" = ? AND ");
		}
		if (!tCode.equals("")) {
			sb.append(COL_TCODE);
			sb.append(" LIKE ? ");
			sb.append("AND ");
		}
		sb.append(COL_TNAME);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (!tId.equals("")) {
				setParam(index++, tId);
			}
			if (!tCode.equals("")) {
				setParam(index++, tCode + "%");
			}
			setParam(index++, "%" + tName + "%");
			executeQuery();
			List<MCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾(p)
	 * @param tId        R[h敪(L[)
	 * @param tCode      R[h(L[)
	 * @param tName      R[h(L[)
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findForHoliday(
			String tId,
			String tCode,
			String tName
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? ");
		if (!tCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_TCODE);
			sb.append(" LIKE ? ");
		}
		sb.append(" AND ");
		sb.append(COL_TNAME);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tId);
			if (!tCode.equals("")) {
				setParam(index++,"%" + tCode + "%");
			}
			setParam(index++, "%" + tName + "%");
			executeQuery();
			List<MCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * Sf[^擾(T_ID̃Xg)
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findAllTId() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT DISTINCT ");
			sb.append(COL_TID);
			sb.append(" FROM ");
			sb.append(TABLE + " ");
			prepareStatement(sb.toString());
			executeQuery();
			List<MCodeDto> all = mappingAllTId();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param tid R[h
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MCodeDto> findForReason(
			String tid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_TID);
		sb.append(" = ? AND ");
		sb.append(COL_TNAME);
		sb.append(" != '' ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tid);
			executeQuery();
			List<MCodeDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getTId());
			setParam(index++, dto.getTCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getTId());
			setParam(index++, dto.getTCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param tid XVΏTID
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(String tid) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_TID);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, tid);
			executeUpdate();
			//chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MCodeDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getTId());		//R[h
		setParam(index++, dto.getTCode());		//R[h
		setParam(index++, dto.getTName());		//R[h
		setParam(index++, dto.getTChange());	//R[hϊ
		setCommonParams(isInsert);
	}

	/**
	 * e[ubN
	 * @param 	tid	XVΏۃe[uID
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(String tid) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(tid);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
